/*
EditPoly Operations MacroScript File

Created:  		Aug 19 2000
Revision History: 	
	
	Feb 25, 2002, by Steve Anderson - heavily reorganized.
	
	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macroscript file can be shared with all Discreet products
	
	28 May 2004, Steve Anderson
		Added support for Edit Poly modifier to most scripts.
	
EditPoly operations Macroscript file.

*/

-- *******************************************************************
--  Poly Ops:  Edit Vertices
-- *******************************************************************

MacroScript EPoly_VCreate
ButtonText:~EPOLY_VCREATE_BUTTONTEXT~
Category:~EPOLY_VCREATE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_VCREATE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode()==#CreateVertex)
		)
		catch ( false )
	)

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			SubObjectLevel = 1
			local A = Filters.GetModOrObj()
			A.toggleCommandMode #CreateVertex
		)
		Catch(MessageBox ~EPOLY_VCREATE_CAPTION~ Title:~EPOLY_VCREATE_TITLE~)
	)
)

MacroScript EPoly_VRemove
ButtonText:~EPOLY_VREMOVE_BUTTONTEXT~
Category:~EPOLY_VREMOVE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_VREMOVE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		try (
			if subobjectlevel == undefined then max modify mode
			if subobjectLevel != 1 then subobjectLevel = 1
			else
			(
				local A = Filters.GetModOrObj()
				if (Filters.Is_This_EditPolyMod A) then A.ButtonOp #RemoveVertex
				else A.buttonOp #Remove
			)
		)
		catch (MessageBox ~EPOLY_VREMOVE_CAPTION~ Title:~EPOLY_VREMOVE_TITLE~)
	)
)

MacroScript EPoly_VBreak
ButtonText:~EPOLY_VBREAK_BUTTONTEXT~
Category:~EPOLY_VBREAK_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_VBREAK_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			If SubObjectLevel != 1 then SubObjectLevel = 1
			else
			(
				local A = Filters.GetModOrObj()
				A.buttonOp #BreakVertex
			)
		)
		Catch(MessageBox ~EPOLY_VBREAK_CAPTION~ Title:~EPOLY_VBREAK_TITLE~)
	)
)

MacroScript EPoly_VExtrude
ButtonText:~EPOLY_VEXTRUDE_BUTTONTEXT~
Category:~EPOLY_VEXTRUDE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_VEXTRUDE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode()==#ExtrudeVertex)
		)
		catch ( false )
	)

	On Execute Do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			SubObjectLevel = 1
			local A = Filters.GetModOrObj()
			A.toggleCommandMode #ExtrudeVertex
		)
		Catch(MessageBox ~EPOLY_VEXTRUDE_CAPTION~ Title:~EPOLY_VEXTRUDE_TITLE~)
	)
	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			SubObjectLevel = 1
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyMod A) then A.PopupDialog #ExtrudeVertex
			else A.popupDialog #Extrude
		)
		Catch(MessageBox ~EPOLY_VEXTRUDE_OPERATION_FAILED_CAPTION~ Title:~EPOLY_VEXTRUDE_OPERATION_FAILED_TITLE~)
	)
)

MacroScript EPoly_VChamfer
ButtonText:~EPOLY_VCHAMFER_BUTTONTEXT~
Category:~EPOLY_VCHAMFER_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_VCHAMFER_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode()==#ChamferVertex)
		)
		catch ( false )
	)

	On Execute Do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			SubObjectLevel = 1
			local A = Filters.GetModOrObj()
			A.toggleCommandMode #ChamferVertex
		)
		Catch(MessageBox ~EPOLY_VCHAMFER_CAPTION~ Title:~EPOLY_VCHAMFER_TITLE~)
	)
	
	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			SubObjectLevel = 1
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyMod A) then A.PopupDialog #ChamferVertex
			else A.popupDialog #Chamfer
		)
		Catch(MessageBox ~EPOLY_VCHAMFER_OP_FAILED_CAPTION~ Title:~EPOLY_VCHAMFER_OP_FAILED_TITLE~)
	)
)

MacroScript EPoly_VWeld
ButtonText:~EPOLY_VWELD_BUTTONTEXT~
Category:~EPOLY_VWELD_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_VWELD_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 1 then subobjectlevel = 1
		else (
			local A = Filters.GetModOrObj()
			if Filters.Is_This_EditPolyMod A then A.buttonOp #WeldVertex
			else A.buttonOp #WeldSelected
		)
	)
	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel != 1 then subobjectlevel = 1
			local A = Filters.GetModOrObj()
			if Filters.Is_This_EditPolyMod A then A.PopupDialog #WeldVertex
			else A.PopupDialog #WeldSelected
		)
		Catch(MessageBox ~EPOLY_VWELD_CAPTION~ Title:~EPOLY_VWELD_TITLE~)
	)
)

MacroScript EPoly_VTargetWeld
ButtonText:~EPOLY_VTARGETWELD_BUTTONTEXT~
Category:~EPOLY_VTARGETWELD_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_VTARGETWELD_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode()==#Weld) and (subobjectlevel == 1)
		)
		catch ( false )
	)

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			if SubObjectLevel != 1 then subobjectLevel = 1
			local A = Filters.GetModOrObj()
			A.toggleCommandMode #Weld
		)
		Catch(MessageBox ~EPOLY_VTARGETWELD_CAPTION~ Title:~EPOLY_VTARGETWELD_TITLE~)
	)
)

MacroScript EPoly_VConnect
ButtonText:~EPOLY_VCONNECT_BUTTONTEXT~
Category:~EPOLY_VCONNECT_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_VCONNECT_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 1 then subobjectlevel = 1
		else
		(
			local A = Filters.GetModOrObj()
			A.buttonOp #ConnectVertices
		)
	)
)

-- *******************************************************************
-- Poly Ops:  Edit Edges
-- *******************************************************************

MacroScript EPoly_ECreate
ButtonText:~EPOLY_ECREATE_BUTTONTEXT~
Category:~EPOLY_ECREATE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_ECREATE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode()==#CreateEdge)
		)
		catch ( false )
	)

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectLevel != 3 then SubObjectLevel = 2		-- (don't change from Border level.)
			local A = Filters.GetModOrObj()
			A.toggleCommandMode #createEdge
		)
		Catch(MessageBox ~EPOLY_ECREATE_OP_FAILED_TOOLTIP~ Title:~EPOLY_ECREATE_OP_FAILED_TITLE~)
	)
)

MacroScript EPoly_ERemove
ButtonText:~EPOLY_EREMOVE_BUTTONTEXT~
Category:~EPOLY_EREMOVE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_EREMOVE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		try (
			if subobjectlevel == undefined then max modify mode
			if subobjectLevel != 2 then subobjectLevel = 2
			else
			(
				local A = Filters.GetModOrObj()
				if (Filters.Is_This_EditPolyMod A) then A.ButtonOp #RemoveEdge
				else A.buttonOp #Remove
			)
		)
		catch (MessageBox ~EPOLY_EREMOVE_OP_FAILED_TOOLTIP~ Title:~EPOLY_EREMOVE_OP_FAILED_TITLE~)
	)
)

MacroScript EPoly_ESplit
ButtonText:~EPOLY_ESPLIT_BUTTONTEXT~
Category:~EPOLY_ESPLIT_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_ESPLIT_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel != 2 then subobjectlevel = 2
			else
			(
				local A = Filters.GetModOrObj()
				A.buttonOp #SplitEdges
			)
		)
		Catch(MessageBox ~EPOLY_ESPLIT_CAPTION~ Title:~EPOLY_ESPLIT_TITLE~)
	)
)

MacroScript EPoly_EInsertVertex
ButtonText:~EPOLY_EINSERTVERTEX_BUTTONTEXT~
Category:~EPOLY_EINSERTVERTEX_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_EINSERTVERTEX_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode()==#DivideEdge)
		)
		catch ( false )
	)


	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectLevel < 2 then subobjectLevel = 2
			if subobjectLevel > 3 then subobjectLevel = 2
			local A = Filters.GetModOrObj()
			A.ToggleCommandMode #DivideEdge
		)
		Catch(MessageBox ~EPOLY_EINSERTVERTEX_CAPTION~ Title:~EPOLY_EINSERTVERTEX_TITLE~)
	)
)

MacroScript EPoly_EExtrude
ButtonText:~EPOLY_EEXTRUDE_BUTTONTEXT~
Category:~EPOLY_EEXTRUDE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_EEXTRUDE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode()==#ExtrudeEdge)
		)
		catch ( false )
	)

	On Execute Do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectLevel < 2 then subobjectLevel = 2
			if subobjectLevel > 3 then subobjectLevel = 2
			local A = Filters.GetModOrObj()
			A.toggleCommandMode #ExtrudeEdge
		)
		Catch(MessageBox ~EPOLY_EEXTRUDE_CAPTION~ Title:~EPOLY_EEXTRUDE_TITLE~)
	)
	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectLevel < 2 then subobjectLevel = 2
			if subobjectLevel > 3 then subobjectLevel = 2
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyMod A) then A.PopupDialog #ExtrudeEdge
			else A.popupDialog #Extrude
		)
		Catch(MessageBox ~EPOLY_EEXTRUDE_OP_FAILED_CAPTION~ Title:~EPOLY_EEXTRUDE_OP_FAILED_TOOLTIP~)
	)
)

MacroScript EPoly_EChamfer
ButtonText:~EPOLY_ECHAMFER_BUTTONTEXT~
Category:~EPOLY_ECHAMFER_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_ECHAMFER_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode()==#ChamferEdge)
		)
		catch ( false )
	)

	On Execute Do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectLevel < 2 then subobjectLevel = 2
			if subobjectLevel > 3 then subobjectLevel = 2
			local A = Filters.GetModOrObj()
			A.toggleCommandMode #ChamferEdge
		)
		Catch(MessageBox ~EPOLY_ECHAMFER_CAPTION~ Title:~EPOLY_ECHAMFER_TITLE~)
	)
	
	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectLevel < 2 then subobjectLevel = 2
			if subobjectLevel > 3 then subobjectLevel = 2
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyMod A) then A.PopupDialog #ChamferEdge
			else A.popupDialog #Chamfer
		)
		Catch(MessageBox ~EPOLY_ECHAMFER_OP_FAILED_CAPTION~ Title:~EPOLY_ECHAMFER_OP_FAILED_TITLE~)
	)
)

MacroScript EPoly_EWeld
ButtonText:~EPOLY_EWELD_BUTTONTEXT~
Category:~EPOLY_EWELD_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_EWELD_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 2 then subobjectlevel = 2
		else
		(
			local A = Filters.GetModOrObj()
			if Filters.Is_This_EditPolyMod A then A.buttonOp #WeldEdge
			else A.buttonOp #WeldSelected
		)
	)
	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel != 2 then subobjectlevel = 2
			local A = Filters.GetModOrObj()
			if Filters.Is_This_EditPolyMod A then A.popupDialog #WeldEdge
			else A.popupDialog #WeldSelected
		)
		Catch(MessageBox ~EPOLY_EWELD_CAPTION~ Title:~EPOLY_EWELD_TITLE~)
	)
)

MacroScript EPoly_ETargetWeld
ButtonText:~EPOLY_ETARGETWELD_BUTTONTEXT~
Category:~EPOLY_ETARGETWELD_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_ETARGETWELD_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode()==#Weld) and (A.GetMeshSelLevel()==#Edge)
		)
		catch ( false )
	)

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			if SubObjectLevel != 2 then subobjectLevel = 2
			local A = Filters.GetModOrObj()
			A.toggleCommandMode #Weld
		)
		Catch(MessageBox ~EPOLY_ETARGETWELD_CAPTION~ Title:~EPOLY_ETARGETWELD_TITLE~)
	)
)

MacroScript EPoly_EConnect
ButtonText:~EPOLY_ECONNECT_BUTTONTEXT~
Category:~EPOLY_ECONNECT_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_ECONNECT_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		Try (
			local A = Filters.GetModOrObj()
			if subobjectlevel == undefined then max modify mode
			if (subobjectLevel == 2) or (subobjectLevel == 3) then A.buttonOp #ConnectEdges
			else subobjectLevel = 2
		)
		Catch(MessageBox ~EPOLY_ECONNECT_CAPTION~ Title:~EPOLY_ECONNECT_TITLE~)
	)

	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectLevel > 3 then subobjectLevel = 2
			if subobjectLevel < 2 then subobjectLevel = 2
			local A = Filters.GetModOrObj()
			A.popupDialog #ConnectEdges
		)
		Catch(MessageBox ~EPOLY_ECONNECT_OP_FAILED_CAPTION~ Title:~EPOLY_ECONNECT_OP_FAILED_TITLE~)
	)
)

MacroScript EPoly_EShapeFromEdges
ButtonText:~EPOLY_ESHAPEFROMEDGES_BUTTONTEXT~
Category:~EPOLY_ESHAPEFROMEDGES_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_ESHAPEFROMEDGES_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			if (subobjectLevel < 2) or (subobjectLevel > 3) then subobjectLevel = 2
			else (
				local A = Filters.GetModOrObj()
				A.buttonOp #CreateShape
			)
		)
		Catch(MessageBox ~EPOLY_ESHAPEFROMEDGES_CAPTION~ Title:~EPOLY_ESHAPEFROMEDGES_TITLE~)
	)
)

-- *******************************************************************
-- Poly Ops:  Edit Borders
-- *******************************************************************

-- Note: Insert Vertex, Extrude, Chamfer, Connect, create Shape, are all handled in Edge above.

MacroScript EPoly_BCap
ButtonText:~EPOLY_BCAP_BUTTONTEXT~
Category:~EPOLY_BCAP_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_BCAP_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel != 3 then subobjectlevel = 3
			else
			(
				local A = Filters.GetModOrObj()
				A.buttonOp #Cap
			)
		)
		Catch(MessageBox ~EPOLY_BCAP_CAPTION~ Title:~EPOLY_BCAP_TITLE~)
	)
)

-- *******************************************************************
--  Poly Ops: Edit Faces
-- *******************************************************************

MacroScript EPoly_FCreate
ButtonText:~EPOLY_FCREATE_BUTTONTEXT~
Category:~EPOLY_FCREATE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_FCREATE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode()==#CreateFace)
		)
		catch ( false )
	)


	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			if (subobjectLevel > 0) and (subobjectLevel < 4) then subobjectLevel = 4
			local A = Filters.GetModOrObj()
			A.toggleCommandMode #CreateFace
		)
		Catch(MessageBox ~EPOLY_FCREATE_CAPTION~ Title:~EPOLY_FCREATE_TITLE~)
	)
)

MacroScript EPoly_FInsertVertex
ButtonText:~EPOLY_FINSERTVERTEX_BUTTONTEXT~
Category:~EPOLY_FINSERTVERTEX_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_FINSERTVERTEX_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode()==#DivideFace)
		)
		catch ( false )
	)


	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectLevel < 4 then subobjectLevel = 4
			local A = Filters.GetModOrObj()
			A.ToggleCommandMode #DivideFace
		)
		Catch(MessageBox ~EPOLY_FINSERTVERTEX_CAPTION~ Title:~EPOLY_FINSERTVERTEX_TITLE~)
	)
)

MacroScript EPoly_FExtrude
ButtonText:~EPOLY_FEXTRUDE_BUTTONTEXT~
Category:~EPOLY_FEXTRUDE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_FEXTRUDE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode()==#ExtrudeFace)
		)
		catch ( false )
	)

	On Execute Do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectLevel < 4 then subobjectLevel = 4
			local A = Filters.GetModOrObj()
			A.toggleCommandMode #ExtrudeFace
		)
		Catch(MessageBox ~EPOLY_FEXTRUDE_CAPTION~ Title:~EPOLY_FEXTRUDE_TITLE~)
	)
	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectLevel < 4 then subobjectLevel = 4
			local A = Filters.GetModOrObj()
			if (Filters.Is_This_EditPolyMod A) then A.PopupDialog #ExtrudeFace
			else A.popupDialog #Extrude
		)
		Catch(MessageBox ~EPOLY_FEXTRUDE_OP_FAILED_CAPTION~ Title:~EPOLY_FEXTRUDE_OP_FAILED_TITLE~)
	)
)

MacroScript EPoly_FBevel
ButtonText:~EPOLY_FBEVEL_BUTTONTEXT~
Category:~EPOLY_FBEVEL_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_FBEVEL_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode()==#Bevel)
		)
		catch ( false )
	)

	On Execute Do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectLevel < 4 then subobjectLevel = 4
			local A = Filters.GetModOrObj()
			A.toggleCommandMode #Bevel
		)
		Catch(MessageBox ~EPOLY_FBEVEL_CAPTION~ Title:~EPOLY_FBEVEL_TITLE~)
	)
	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectLevel < 4 then subobjectLevel = 4
			local A = Filters.GetModOrObj()
			A.popupDialog #Bevel
		)
		Catch(MessageBox ~EPOLY_FBEVEL_OP_FAILED_CAPTION~ Title:~EPOLY_FBEVEL_OP_FAILED_TITLE~)
	)
)

MacroScript EPoly_FOutline
ButtonText:~EPOLY_FOUTLINE_BUTTONTEXT~
Category:~EPOLY_FOUTLINE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_FOUTLINE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode()==#OutlineFace)
		)
		catch ( false )
	)

	On Execute Do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectLevel < 4 then subobjectLevel = 4
			local A = Filters.GetModOrObj()
			A.toggleCommandMode #OutlineFace
		)
		Catch(MessageBox ~EPOLY_FOUTLINE_CAPTION~ Title:~EPOLY_FOUTLINE_TITLE~)
	)
	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectLevel < 4 then subobjectLevel = 4
			local A = Filters.GetModOrObj()
			A.popupDialog #Outline
		)
		Catch(MessageBox ~EPOLY_FOUTLINE_OP_FAILED_CAPTION~ Title:~EPOLY_FOUTLINE_OP_FAILED_TITLE~)
	)
)

MacroScript EPoly_FInset
ButtonText:~EPOLY_FINSET_BUTTONTEXT~
Category:~EPOLY_FINSET_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_FINSET_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode()==#InsetFace)
		)
		catch ( false )
	)

	On Execute Do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectLevel < 4 then subobjectLevel = 4
			local A = Filters.GetModOrObj()
			A.toggleCommandMode #InsetFace
		)
		Catch(MessageBox ~EPOLY_FINSET_CAPTION~ Title:~EPOLY_FINSET_TITLE~)
	)
	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectLevel < 4 then subobjectLevel = 4
			local A = Filters.GetModOrObj()
			A.popupDialog #Inset
		)
		Catch(MessageBox ~EPOLY_FINSET_OP_FAILED_CAPTION~ Title:~EPOLY_FINSET_OP_FAILED_TITLE~)
	)
)

MacroScript EPoly_FRetriangulate
ButtonText:~EPOLY_FRETRIANGULATE_BUTTONTEXT~
Category:~EPOLY_FRETRIANGULATE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_FRETRIANGULATE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		Try	(
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectlevel < 4 then subobjectlevel = 4
			else 
			(
				local A = Filters.GetModOrObj()
				A.buttonOp #Retriangulate
			)
		)
		Catch(MessageBox ~EPOLY_FRETRIANGULATE_CAPTION~ Title:~EPOLY_FRETRIANGULATE_TITLE~)
	)
)

MacroScript EPoly_FFlip
ButtonText:~EPOLY_FFLIP_BUTTONTEXT~
Category:~EPOLY_FFLIP_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_FFLIP_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do
	(
		If SubObjectLevel == undefined then Max Modify Mode
		-- default to Element level here:
		If SubObjectLevel < 4 then SubObjectLevel = 5
		else (
			Try(
				local A = Filters.GetModOrObj()
				if (Filters.Is_This_EditPolyMod A) then
				(
					if (subobjectlevel == 4) then A.ButtonOp #FlipFace
					else A.ButtonOp #FlipElement
				)
				else A.buttonOp #FlipNormals
			)
			Catch(MessageBox ~EPOLY_FFLIP_CAPTION~ Title:~EPOLY_FFLIP_TITLE~)
		)
	)

)

MacroScript EPoly_FHinge
ButtonText:~EPOLY_FHINGE_BUTTONTEXT~
Category:~EPOLY_FHINGE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_FHINGE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		try (
			local A = Filters.GetModOrObj()
			(Filters.Is_This_EditPolyMod A) and (A.GetCommandMode()==#HingeFromEdge)
		)
		catch ( false )
	)

	On Execute Do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectLevel != 4 then subobjectLevel = 4
			local A = Filters.GetModOrObj()
			A.toggleCommandMode #HingeFromEdge
		)
		Catch(MessageBox ~EPOLY_FHINGE_CAPTION~ Title:~EPOLY_FHINGE_TITLE~)
	)
	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectLevel != 4 then subobjectLevel = 4
			local A = Filters.GetModOrObj()
			A.PopupDialog #HingeFromEdge
		)
		Catch(MessageBox ~EPOLY_FHINGE_OP_FAILED_CAPTION~ Title:~EPOLY_FHINGE_OP_FAILED_TITLE~)
	)
)

MacroScript EPoly_FExtrude_Along_Spline
ButtonText:~EPOLY_FEXTRUDE_ALONG_SPLINE_BUTTONTEXT~
Category:~EPOLY_FEXTRUDE_ALONG_SPLINE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_FEXTRUDE_ALONG_SPLINE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectLevel != 4 then subobjectLevel = 4
			local A = Filters.GetModOrObj()
			A.enterPickMode #pickShape
		)
		Catch(MessageBox ~EPOLY_FEXTRUDE_ALONG_SPLINE_CAPTION~ Title:~EPOLY_FEXTRUDE_ALONG_SPLINE_TITLE~)
	)
	On AltExecute type do (
		Try (
			If SubObjectLevel == undefined then Max Modify Mode
			if subobjectLevel != 4 then subobjectLevel = 4
			local A = Filters.GetModOrObj()
			A.popupDialog #ExtrudeAlongSpline
		)
		Catch(MessageBox ~EPOLY_FEXTRUDE_ALONG_SPLINE_OP_FAILED_CAPTION~ Title:~EPOLY_FEXTRUDE_ALONG_SPLINE_OP_FAILED_TITLE~)
	)
)

MacroScript EPoly_Toggle_Normal_Constraint
ButtonText:~EPOLY_TOGGLE_NORMAL_CONSTRAINT_BUTTONTEXT~
Category:~EPOLY_TOGGLE_NORMAL_CONSTRAINT_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_TOGGLE_NORMAL_CONSTRAINT_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		Try (
			local A = Filters.GetModOrObj()
			(A.constrainType == 3)
		)
		Catch ( false )
	)

	On Execute Do (
		Try (
			local A = Filters.GetModOrObj()
			if A.constrainType == 3 then (A.constrainType = 0)
			else (A.constrainType = 3)
		)
		Catch (MessageBox ~EPOLY_TOGGLE_NORMAL_CONSTRAINT_CAPTION~ Title:~EPOLY_TOGGLE_NORMAL_CONSTRAINT_TITLE~)
	)
)

MacroScript EPoly_Preview_Select_Mode
ButtonText:~EPOLY_PREVIEW_SELECT_MODE_BUTTONTEXT~
Category:~EPOLY_PREVIEW_SELECT_MODE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_PREVIEW_SELECT_MODE_TOOLTIP~ 
-- Needs Icon
(	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()

	On Execute Do (
		Try (
			local A = Filters.GetModOrObj()
			if A.selectMode == 2 then (A.selectMode = 0)
			else (A.selectMode = A.selectMode+1)
		)
		Catch (MessageBox ~EPOLY_PREVIEW_SELECT_MODE_CAPTION~ Title:~EPOLY_PREVIEW_SELECT_MODE_TITLE~)
	)
)



MacroScript EPoly_SoftSel_Lock_Toggle
ButtonText:~EPOLY_SOFTSEL_LOCK_TOGGLE_BUTTONTEXT~
Category:~EPOLY_SOFTSEL_LOCK_TOGGLE_CATEGORY~ 
internalCategory:"Editable Polygon Object" 
Tooltip:~EPOLY_SOFTSEL_LOCK_TOGGLE_TOOLTIP~ 
-- Needs Icon
(
	On IsEnabled Return Filters.Is_EPoly()
	On IsVisible Return Filters.Is_EPoly()
	On IsChecked Do (
		Try (
			local A = Filters.GetModOrObj()
			A.lockSoftSel
		)
		Catch ( false )
	)

	On Execute Do
	(
		
		Try	
		(
			local A = Filters.GetModOrObj()
			A.lockSoftSel = (not A.lockSoftSel)
		)
		Catch(MessageBox ~EPOLY_SOFTSEL_LOCK_TOGGLE_CAPTION~ Title:~EPOLY_SOFTSEL_LOCK_TOGGLE_TITLE~)
	)

)



-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQA5TRnd2A1dybGoxyMVpdr7WRUR+hVfgZgG
-- vIEW9t9OuuhA65BVZIGFWDEePZLkHRi90DjXyc8/OrPYb1BYBfTWpZ25tcRjrLMg
-- YSsvF3s17UKEuCjyo2DVyuVkd+Buns3UmGFb47NgkUAAOXTtpNVYVl60+95NJEx1
-- vgsN1i01p6hx2GpGyMB8YZQP2IlxN74Sqxi6wnzF8UGt34kTyZXSmC1pR2Ff68DP
-- Axbw2FH609lH5oCmqaZ01edJOIr2eNtk+N2465StaFVnNQB5xQW7UTw2WoHPxvMG
-- A/8BIjad122rPsdxk8v4HgWA2QYcI4qnuD0rZfAwQs02ACavsxp7
-- -----END-SIGNATURE-----